/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.entity.EntityNPCInterface;

public class BankData {
    public Bank bank;
    public final Map<Integer, NpcMiscInventory> cells = new TreeMap<Integer, NpcMiscInventory>();
    private final String uuid;

    public BankData(Bank bank, String uuid) {
        this.bank = bank;
        this.uuid = uuid;
        if (this.bank == null) {
            this.bank = new Bank();
        }
        this.clear();
    }

    public void clear() {
        this.cells.clear();
        boolean isStart = true;
        for (int ceil : this.bank.ceilSettings.keySet()) {
            Bank.CeilSettings cs = this.bank.ceilSettings.get(ceil);
            if (isStart) {
                isStart = cs.openStack.func_190926_b();
            }
            this.cells.put(ceil, new NpcMiscInventory(isStart ? cs.startCells : 0));
        }
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound nbtBD = new NBTTagCompound();
        nbtBD.func_74768_a("id", this.bank.id);
        NBTTagList list = new NBTTagList();
        for (int ceil : this.cells.keySet()) {
            NBTTagCompound nbtCeil = new NBTTagCompound();
            nbtCeil.func_74768_a("ceil", ceil);
            nbtCeil.func_74768_a("slots", this.cells.get(ceil).func_70302_i_());
            NBTTagCompound invNbt = this.cells.get(ceil).save();
            nbtCeil.func_74782_a("NpcMiscInv", invNbt.func_74781_a("NpcMiscInv"));
            list.func_74742_a((NBTBase)nbtCeil);
        }
        nbtBD.func_74782_a("cells", (NBTBase)list);
        return nbtBD;
    }

    public UUID getUUID() {
        return UUID.fromString(this.uuid);
    }

    public void openBankGui(EntityPlayer player, EntityNPCInterface npc, int ceil) {
        if (!this.cells.containsKey(ceil) || !(player instanceof EntityPlayerMP)) {
            return;
        }
        if (this.bank.isPublic && !player.field_71075_bZ.field_75098_d && !this.bank.access.isEmpty() && !this.bank.owner.equals(player.func_70005_c_()) && (this.bank.isWhiteList && !this.bank.access.contains(player.func_70005_c_()) || !this.bank.isWhiteList && this.bank.access.contains(player.func_70005_c_()))) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.bank.not.access", new Object[0]));
            return;
        }
        NBTTagCompound nbtBank = new NBTTagCompound();
        this.bank.writeToNBT(nbtBank);
        Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.BankData, nbtBank});
        NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerBank, npc, this.bank.id, ceil, this.cells.get(ceil).func_70302_i_());
    }

    public void readNBT(NBTTagCompound nbtBD) {
        this.bank = BankController.getInstance().banks.get(nbtBD.func_74762_e("id"));
        NBTTagList list = nbtBD.func_150295_c("cells", 10);
        if (list.func_74745_c() == 0 && nbtBD.func_150297_b("ceils", 9)) {
            list = nbtBD.func_150295_c("ceils", 10);
        }
        this.cells.clear();
        for (int ceil = 0; ceil < list.func_74745_c(); ++ceil) {
            NBTTagCompound nbtCeil = list.func_150305_b(ceil);
            NpcMiscInventory inv = new NpcMiscInventory(nbtCeil.func_74762_e("slots"));
            inv.load(nbtCeil);
            this.cells.put(nbtCeil.func_74762_e("ceil"), inv);
        }
    }

    public void save() {
        File dir = this.bank.isPublic ? CustomNpcs.getWorldSaveDirectory("banks") : CustomNpcs.getWorldSaveDirectory("playerdata/" + this.uuid + "/banks");
        File bankFile = new File(dir, this.bank.id + ".dat");
        if (!bankFile.exists()) {
            try {
                bankFile.createNewFile();
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        LogWriter.debug("Bank ID: " + this.bank.id + " save " + (this.bank.isPublic ? "Public" : "Player \"" + this.uuid + "\"") + " Inventory's");
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)Files.newOutputStream(bankFile.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public void setNBT(NBTTagCompound nbtBD) {
        this.bank = BankController.getInstance().banks.get(nbtBD.func_74762_e("id"));
        NBTTagList list = nbtBD.func_150295_c("cells", 10);
        for (int ceil = 0; ceil < list.func_74745_c(); ++ceil) {
            NBTTagCompound nbtCeil = list.func_150305_b(ceil);
            NpcMiscInventory inv = new NpcMiscInventory(nbtCeil.func_74762_e("slots"));
            inv.load(nbtCeil);
            this.cells.put(nbtCeil.func_74762_e("ceil"), inv);
        }
    }
}

